import { StarXpandCommand } from "star-io10-web";

export class LabelSample03_For203dpi_PharmacyMedication1_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 75.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "pharmacy_medication1_logo.png",
                    0.0,
                    0.0,
                    130,
                  ),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(54.0, 20.0)
                    .setX(18.0)
                    .setY(0.0),
                  new StarXpandCommand.PageModeBuilder()
                    .styleHorizontalPositionTo(0.0)
                    .styleVerticalPositionTo(4.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText("${store_name}\n")
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(1, 1),
                    )
                    .actionPrintText("${address}\n")
                    .actionPrintText("${telephone_number}\n"),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(
                    72.0,
                    20.0,
                  ).setY(20.0),
                  new StarXpandCommand.PageModeBuilder()
                    .actionPrintRectangle(
                      new StarXpandCommand.Printer.PageModeRectangleParameter(
                        0.0,
                        0.0,
                        72.0,
                        16.0,
                      ),
                    )
                    .styleHorizontalPositionTo(1.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(4.0)
                    .actionPrintText("${number}\n")
                    .styleHorizontalPositionTo(1.0)
                    .styleVerticalPositionBy(4.0)
                    .actionPrintText("${customer_name}"),
                )
                .styleVerticalPositionTo(40.0)
                .actionPrintText("Usage:\n")
                .styleBold(true)
                .actionPrintText("${usage}\n")
                .styleBold(false)
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(
                    72.0,
                    10.0,
                  ).setY(55.0),
                  new StarXpandCommand.PageModeBuilder()
                    .actionPrintRectangle(
                      new StarXpandCommand.Printer.PageModeRectangleParameter(
                        0.0,
                        0.0,
                        72.0,
                        8.0,
                      ),
                    )
                    .styleHorizontalPositionTo(1.0)
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .styleVerticalPositionTo(4.0)
                    .actionPrintText("□ Refill\t□ No Refill\n"),
                )
                .styleVerticalPositionTo(65.0)
                .actionPrintText("EXP: ${expiry_date}\n")
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 1),
                    )
                    .actionPrintText("Quantity: ${quantity}\n"),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "store_name" : "Local Pharmacy",
    "address" : "123 HIGH STREET\\nLONDON, SWA1A 1AA",
    "telephone_number" : "(111)222 333",
    "number" : "Rx: 860015 - 5100",
    "customer_name" : "SMITH, JOHN",
    "usage" : "TAKE ONE TABLET ONCE DAILY",
    "expiry_date" : "3/24",
    "quantity" : "50 TABLETS"
}`,
    );
  }
}
